import { User } from '../domain/entities/user.entity';
import { UserRepository } from '../infrastructure/repositories/user.repository';

export class GetUserUseCase {
  private userRepository: UserRepository;

  constructor(userRepository: UserRepository) {
    this.userRepository = userRepository;
  }

  public async execute(id: string): Promise<User> {
    const user = await this.userRepository.findById(id);
    return user;
  }
}