import { GetUserUseCase } from '../usecases/get-user.usecase';

export class UserController {
  private getUserUseCase: GetUserUseCase;

  constructor(getUserUseCase: GetUserUseCase) {
    this.getUserUseCase = getUserUseCase;
  }

  public async getUser(req: any, res: any): Promise<void> {
    const id = req.params.id;
    const user = await this.getUserUseCase.execute(id);
    res.json(user);
  }
}