// Import required modules
import { useState } from 'react';

// Define the KeyboardNavigation component
function KeyboardNavigation() {
  const [activeIndex, setActiveIndex] = useState(0);

  // Handle next button click
  const handleNextClick = () => {
    setActiveIndex(activeIndex + 1);
  };

  // Handle previous button click
  const handlePreviousClick = () => {
    setActiveIndex(activeIndex - 1);
  };

  return (
    <div>
      <button aria-label="Navigate to next element" type="button" onClick={handleNextClick}>Next</button>
      <button aria-label="Navigate to previous element" type="button" onClick={handlePreviousClick}>Previous</button>
    </div>
  );
}

// Export the KeyboardNavigation component
export default KeyboardNavigation;