// Import required modules
import { createServer } from 'http';
import { parse } from 'url';
import { fileURLToPath } from 'url';
import { dirname } from 'path';
import { readFileSync } from 'fs';

// Define the server
const server = createServer((req, res) => {
    // Parse the URL
    const { pathname } = parse(req.url);

    // Get the file path
    const filePath = fileURLToPath(new URL(pathname, import.meta.url));

    // Get the file extension
    const fileExtension = filePath.split('.').pop();

    // Serve the file
    if (fileExtension === 'html') {
        res.writeHead(200, {
            'Content-Type': 'text/html; charset=UTF-8'
        });
        res.end(readFileSync(filePath, 'utf8'));
    } else if (fileExtension === 'js') {
        res.writeHead(200, {
            'Content-Type': 'application/javascript; charset=UTF-8'
        });
        res.end(readFileSync(filePath, 'utf8'));
    } else if (fileExtension === 'css') {
        res.writeHead(200, {
            'Content-Type': 'text/css; charset=UTF-8'
        });
        res.end(readFileSync(filePath, 'utf8'));
    } else {
        res.writeHead(404, {
            'Content-Type': 'text/plain; charset=UTF-8'
        });
        res.end('Not Found');
    }
});

// Start the server
server.listen(3000, () => {
    console.log('Server started on port 3000');
});