# Clean Architecture Project

## Overview
This project follows the clean architecture pattern to ensure a maintainable and scalable codebase.

## Dependencies
- Node.js (14.x or higher)
- Jest (27.x or higher)
- React (18.x or higher)

## Setup
1. Clone the repository.
2. Run `npm install` to install dependencies.
3. Run `npm start` to start the development server.
4. Run `npm test` to run unit tests.

## Testing Framework
We use Jest as our testing framework to ensure UI components and interactivity are working as expected.

## Clean Architecture
The project is structured as follows:
- `src`: The main source code directory.
  - `components`: UI components.
  - `containers`: Container components.
  - `models`: Data models.
  - `services`: Business logic services.
  - `utils`: Utility functions.
- `tests`: Unit tests and integration tests.
- `public`: Static assets.
