// index.ts

import express, { Request, Response } from 'express';
import { Container } from 'typescript-ioc';

const app = express();

// Register dependencies
Container.register('Logger', () => {
  return {
    log: (message: string) => console.log(message),
  };
});

// Start the application
const port = 3000;
app.listen(port, () => {
  console.log(`Server started on port ${port}`);
});
