module.exports = {
  // Define the entry point
  entry: './src/index.js',

  // Define the output file
  output: {
    path: __dirname + '/dist',
    filename: 'bundle.js',
  },

  // Define the module rules
  module: {
    rules: [
      {
        test: /.js$/, // Check for JavaScript files
        exclude: /node_modules/, // Exclude node_modules directory
        use: {
          loader: 'babel-loader', // Use Babel loader
          options: {
            presets: ['@babel/preset-env'], // Use Babel preset for ES6+ syntax
          },
        },
      },
      {
        test: /.css$/, // Check for CSS files
        use: ['style-loader', 'css-loader'], // Use style and CSS loaders
      },
    ],
  },
};