// src/utils/dom.js

// Import dependencies
import { JSDOM } from 'jsdom';

// Define the DOM utility functions
function createElement(tagName, attributes, content) {
  const dom = new JSDOM(`<!DOCTYPE html><html><body></body></html>`);
  const document = dom.window.document;
  const element = document.createElement(tagName);
  if (attributes) {
    Object.keys(attributes).forEach((key) => {
      element.setAttribute(key, attributes[key]);
    });
  }
  if (content) {
    element.textContent = content;
  }
  return element;
}

// Export the DOM utility functions
export { createElement };