package com.example;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class ReadmeGenerator {

    public static void main(String[] args) {
        List<File> files = new ArrayList<>();

        // Add files to the list
        files.add(new File("src/main/java/com/example/ReadmeGenerator.java", "This is the ReadmeGenerator class."));
        files.add(new File("src/main/java/com/example/ReadmeGenerator.java", "This is the ReadmeGenerator class."));

        // Write the files to the README.md file
        try (PrintWriter writer = new PrintWriter(new FileWriter("README.md"))) {
            for (File file : files) {
                writer.println("### " + file.getName() + "");
                writer.println(file.getContent());
                writer.println();
            }
        } catch (IOException e) {
            System.err.println("Error writing to README.md: " + e.getMessage());
        }
    }

    private static class File {
        private final String name;
        private final String content;

        public File(String name, String content) {
            this.name = name;
            this.content = content;
        }

        public String getName() {
            return name;
        }

        public String getContent() {
            return content;
        }
    }
}