import React from 'react';
import { LinkProps } from './Link.types';

const Link: React.FC<LinkProps> = ({
  children,
  href,
  onClick,
  ariaLabel,
  'aria-label': _ariaLabel,
  ...props
}) => {
  return (
    <a
      href={href}
      onClick={onClick}
      aria-label={ariaLabel}
      {...props}
    >
      {children}
    </a>
  );
};

export default Link;