import React from 'react';
import { InputProps } from './Input.types';

const Input: React.FC<InputProps> = ({
  children,
  onChange,
  value,
  ariaLabel,
  'aria-label': _ariaLabel,
  ...props
}) => {
  return (
    <input
      type='text'
      value={value}
      onChange={onChange}
      aria-label={ariaLabel}
      {...props}
    />
  );
};

export default Input;