import React from 'react';
import { ButtonProps } from './Button.types';

const Button: React.FC<ButtonProps> = ({
  children,
  onClick,
  ariaLabel,
  'aria-label': _ariaLabel,
  ...props
}) => {
  return (
    <button
      type='button'
      onClick={onClick}
      aria-label={ariaLabel}
      {...props}
    >
      {children}
    </button>
  );
};

export default Button;