import React from 'react';
import Button from './components/Button';
import Input from './components/Input';
import Link from './components/Link';

function App() {
  const [inputValue, setInputValue] = React.useState('');

  const handleInputChange = (event: React.ChangeEvent<HTMLInputElement>) => {
    setInputValue(event.target.value);
  };

  return (
    <div>
      <Button aria-label='Submit Button'>Submit</Button>
      <Input
        aria-label='Input Field'
        value={inputValue}
        onChange={handleInputChange}
      />
      <Link aria-label='Link' href='#'>
        Link
      </Link>
    </div>
  );
}

export default App;