import { User } from '../entities/user';
import { Database } from '../frameworks-and-drivers/database/database';

export class GetUserUseCase {
  private database: Database;

  constructor(database: Database) {
    this.database = database;
  }

  async execute(id: string): Promise<User> {
    const user = await this.database.getUser(id);
    return user;
  }
}