import { GetUserUseCase } from '../use-cases/user/use-case';

export class HttpGetUserAdapter {
  private useCase: GetUserUseCase;

  constructor(useCase: GetUserUseCase) {
    this.useCase = useCase;
  }

  async execute(id: string): Promise<any> {
    const user = await this.useCase.execute(id);
    return user;
  }
}