# Clean Architecture Project Setup

## Table of Contents
* [Setup](#setup)
* [Install](#install)
* [Environment](#environment)
* [Deployment](#deployment)

## Setup

1. Clone the repository using `git clone https://github.com/your-username/your-repo-name.git`
2. Install dependencies using `npm install` or `yarn install`

## Install

1. Install Node.js (14.17.0 or higher) and npm (6.14.13 or higher)
2. Install dependencies using `npm install` or `yarn install`

## Environment

1. Create a `.env` file in the root directory with the following variables:

    ```bash
    DB_HOST=localhost
    DB_USER=root
    DB_PASSWORD=password
    DB_NAME=database
    
    ```

2. Update the `database` variable in `src/config/database.ts` to match your database configuration

## Deployment

1. Build the application using `npm run build` or `yarn build`
2. Start the application using `npm start` or `yarn start`
3. Access the application at `http://localhost:3000`

## Clean Architecture

This project follows the clean architecture pattern, with the following layers:

* **Entities**: Represent the business domain, e.g. `src/entities/user.ts`
* **Use Cases**: Define the business logic, e.g. `src/use-cases/user/use-case.ts`
* **Interface Adapters**: Handle input/output operations, e.g. `src/interface-adapters/http/http.ts`
* **Frameworks and Drivers**: Interact with external systems, e.g. `src/frameworks-and-drivers/database/database.ts`

## Commit Messages

Follow the conventional commit message format:

* `feat`: A new feature
* `fix`: A bug fix
* `docs`: Changes to documentation
* `style`: Changes to code style
* `refactor`: A code change that neither fixes a bug nor adds a feature
* `perf`: A change that improves performance
* `test`: Adding missing tests or correcting existing ones
* `chore`: Changes to the build process or auxiliary tools and libraries such as documentation generation
