package com.example.cleanarchitecture.presentation.controllers;

import com.example.cleanarchitecture.domain.usecases.UserUseCase;

import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserController {

    private final UserUseCase userUseCase;

    public UserController(UserUseCase userUseCase) {
        this.userUseCase = userUseCase;
    }

    @GetMapping("/users")
    public User getUsers() {
        return userUseCase.execute();
    }

}