# Clean Architecture Project Setup

## Overview
This project follows the clean architecture pattern, separating the application logic into layers.

## Project Structure
```bash
src/
├── domain/
│   ├── entities/
│   ├── usecases/
│   └── repositories/
├── data/
│   ├── repositories/
│   └── mappers/
├── presentation/
│   ├── controllers/
│   └── interfaces/
├── application/
│   ├── usecases/
│   └── interfaces/
└── infrastructure/
    ├── config/
    ├── database/
    └── services/
```

## Setup Instructions
### Prerequisites
* Java 11 or higher
* Maven 3.6 or higher
* Git

### Step 1: Clone the Repository
```bash
git clone https://github.com/your-username/your-repo-name.git
```
### Step 2: Install Dependencies
```bash
mvn clean install
```
### Step 3: Configure Database Connection
Create a `application.properties` file in the `src/main/resources` directory with your database connection details.
```properties
database.url=jdbc:mysql://localhost:3306/your-database-name
database.username=your-username
database.password=your-password
```
### Step 4: Run the Application
```bash
mvn spring-boot:run
```
### Step 5: Test the Application
Use Postman or a similar tool to send requests to the application endpoints.

## Commit Messages
Follow the conventional commit message format: `type(scope): subject

## API Documentation
Use Swagger or a similar tool to generate API documentation.
