import { Router } from 'express';
import { UserRepository } from '../infrastructure/repositories/UserRepository';

const router = Router();
const userRepository = new UserRepository();

router.get('/users', async (req, res) => {
  const users = await userRepository.getAllUsers();
  res.json(users);
});

router.get('/users/:id', async (req, res) => {
  const id = req.params.id;
  const user = await userRepository.getUserById(id);
  if (user) {
    res.json(user);
  } else {
    res.status(404).json({ message: 'User not found' });
  }
});

export default router;