import { Database } from '../infrastructure/db/Database';
import { UserRepository } from '../data/repositories/UserRepository';

export class UserController {
  private database: Database;

  constructor() {
    this.database = new Database();
  }

  async getAllUsers(): Promise<User[]> {
    const userRepository = await this.database.getUserRepository();
    return userRepository.getAllUsers();
  }

  async getUserById(id: string): Promise<User | null> {
    const userRepository = await this.database.getUserRepository();
    return userRepository.getUserById(id);
  }

  async createUser(user: User): Promise<void> {
    const userRepository = await this.database.getUserRepository();
    userRepository.createUser(user);
  }
}