// Import required modules
import { App } from './app/app';
import { Container } from 'inversify';
import { config } from './config/config';

// Create the container
const container = new Container();

// Bind dependencies
container.bind<App>('App').toSelf();
container.bind<Config>('Config').toConstantValue(config);

// Create the application
const app = new App(container);

// Start the application
app.start();
