// Import required modules
import { Container } from 'inversify';
import { AppController } from './app.controller';
import { AppService } from './app.service';

// Create the container
const container = new Container();

// Bind dependencies
container.bind<AppController>('AppController').toSelf();
container.bind<AppService>('AppService').toSelf();

// Create the application controller
const appController = container.get<AppController>('AppController');

// Start the application
appController.start();
