// Import the typeorm module
import { createConnection } from 'typeorm';

// Define the database connection options
export const databaseOptions = {
  type: 'postgres',
  url: process.env.DATABASE_URL,
  entities: [__dirname + '/../**/*.entity{.ts,.js}'],
  synchronize: true,
};

// Export the database connection function
export function connectDatabase(): Promise<void> {
  return createConnection(databaseOptions).then(connection => {
    console.log('Database connected successfully');
  });
}