// @ts-check
import React from 'react';
import FishCard from './FishCard';

interface FishListProps {
  fish: Fish[];
}

const FishList = ({ fish }: FishListProps) => {
  return (
    <div className="fish-list">
      {fish.map((fish) => (
        <FishCard key={fish.id} name={fish.name} species={fish.species} image={fish.image} />
      ))}
    </div>
  );
};

export default FishList;