// @ts-check
import React, { useState } from 'react';

interface FishFilterProps {
  fish: Fish[];
  onFilter: (filteredFish: Fish[]) => void;
}

const FishFilter = ({ fish, onFilter }: FishFilterProps) => {
  const [filter, setFilter] = useState('');

  const filteredFish = fish.filter((f) => f.name.toLowerCase().includes(filter.toLowerCase()));

  const handleFilterChange = (event: React.ChangeEvent<HTMLInputElement>) => {
    setFilter(event.target.value);
    onFilter(filteredFish);
  };

  return (
    <div className="fish-filter">
      <input type="text" value={filter} onChange={handleFilterChange} placeholder="Search by name" />
      <button onClick={() => onFilter(fish)}>Clear filter</button>
    </div>
  );
};

export default FishFilter;