// @ts-check
import React from 'react';

interface FishDetailProps {
  fish: Fish;
}

const FishDetail = ({ fish }: FishDetailProps) => {
  return (
    <div className="fish-detail">
      <h1>{fish.name}</h1>
      <p>Species: {fish.species}</p>
      <p>Description: {fish.description}</p>
      <img src={fish.image} alt={fish.name} />
    </div>
  );
};

export default FishDetail;