// @ts-check
import React from 'react';
import FishList from './FishList';
import FishFilter from './FishFilter';
import FishDetail from './FishDetail';

interface FishCatalogProps {
  fish: Fish[];
}

const FishCatalog = ({ fish }: FishCatalogProps) => {
  return (
    <div className="fish-catalog">
      <FishFilter fish={fish} onFilter={(filteredFish) => console.log(filteredFish)} />
      <FishList fish={fish} />
      <FishDetail fish={fish[0]} />
    </div>
  );
};

export default FishCatalog;