// @ts-check
import React from 'react';

interface FishCardProps {
  name: string;
  species: string;
  image: string;
}

const FishCard = ({ name, species, image }: FishCardProps) => {
  return (
    <div className="fish-card">
      <h2>{name}</h2>
      <p>Species: {species}</p>
      <img src={image} alt={name} />
    </div>
  );
};

export default FishCard;