import { UserController } from './UserController';
import { UserRepository } from '../data/repositories/UserRepository';

export class UserController {
  private _userRepository: UserRepository;

  constructor(userRepository: UserRepository) {
    this._userRepository = userRepository;
  }

  async getAllUsers(): Promise<User[]> {
    return this._userRepository.getAllUsers();
  }

  async getUserById(id: string): Promise<User | null> {
    return this._userRepository.getUserById(id);
  }
}