import { User } from '../domain/entities/User';

export class UserRepository {
  private _users: User[];

  constructor() {
    this._users = [];
  }

  async getAllUsers(): Promise<User[]> {
    return this._users;
  }

  async getUserById(id: string): Promise<User | null> {
    return this._users.find((user) => user.id === id) || null;
  }
}