# Clean Architecture Project

This is a clean architecture project built with Node.js and TypeScript.

## Table of Contents

* [Getting Started](#getting-started)
* [Project Structure](#project-structure)
* [Usage](#usage)

## Getting Started

### Prerequisites

* Node.js (14.17.0 or higher)
* npm (6.14.13 or higher)
* TypeScript (4.6.3 or higher)

### Installation

```bash
npm install
```

### Running the Project

```bash
npm start
```

## Project Structure

* `src/`: Source code directory
* `src/main`: Main application code
* `src/main/controllers`: Controller layer
* `src/main/services`: Service layer
* `src/main/repositories`: Repository layer
* `src/main/models`: Model layer
* `src/main/utils`: Utility functions
* `src/test`: Test code directory

## Usage

This project uses the clean architecture pattern. The main application code is located in `src/main`. The project can be run using the `npm start` command.
