// User model
import { Model, DataTypes } from 'sequelize';

const User = (sequelize: Model) => {
  return sequelize.define('User', {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    name: {
      type: DataTypes.STRING,
    },
    email: {
      type: DataTypes.STRING,
      unique: true,
    },
  },
  {
    timestamps: false,
  },
  {
    sequelize,
  },
);

export default User;