// User controller
import { Request, Response } from 'express';
import { User } from '../models/User';

const UserController = {
  async getUser(req: Request, res: Response) {
    const user = await User.findOne({ where: { id: req.params.id } });
    if (!user) {
      return res.status(404).send({ message: 'User not found' });
    }
    return res.send(user);
  },

  async getUsers(req: Request, res: Response) {
    const users = await User.findAll();
    return res.send(users);
  },
}

export default UserController;