// Import required modules
import { Config } from './interfaces/config.interface';

// Define the configuration interface
interface Config {
  db: {
    host: string;
    port: number;
    name: string;
    user: string;
    password: string;
  };
}

// Export the configuration interface
export const config: Config = {
  db: {
    host: process.env.DB_HOST,
    port: parseInt(process.env.DB_PORT),
    name: process.env.DB_NAME,
    user: process.env.DB_USER,
    password: process.env.DB_PASSWORD,
  },
};