# Analyze requirements

You are an autonomous senior software engineer. Build a production-ready single page web application that fully satisfies the user request.

User request:
Design a single-page portfolio highlighting three flagship projects, published client testimonials, and a contact form to request consultations.

Quality corrections (attempt 2):
1. Add a hero section with a standout introduction (include class or id "hero").
2. Include at least three distinct project cards within the projects grid.
3. Provide a contact form capturing name, email, and message with proper accessibility labels.
4. Highlight a clear call-to-action within the hero or contact section.

Execute the following directives precisely:
1. Add a prominent <header class="hero"> with a compelling headline, supportive paragraph, and a primary call-to-action button that scrolls to the contact form.
2. Create <section class="projects-grid"> containing at least three unique project cards that include titles, captions, tech stacks, and a "View case study" link or button.
3. Implement <form id="contact-form"> with labeled inputs for name and email, a textarea for the message, inline validation, and success feedback announced via ARIA live regions.
4. Highlight clear calls-to-action in both the hero and contact sections, encouraging hiring managers to initiate a conversation.
5. Produce polished inline HTML with embedded <style> and <script> blocks that satisfy every quality correction listed.
6. Do not reuse the previous attempt—generate fresh content that fully addresses the feedback.

Delivery checklist:
- Return a single self-contained `index.html` file with inline `<style>` and `<script>` blocks. No external files, build tools, or dependencies.
- Craft a polished hero section, descriptive content, and at least one interactive widget directly related to the request.
- Provide realistic, domain-specific copy (never use placeholder text such as "Lorem ipsum").
- Ensure responsive layout for mobile, tablet, and desktop using semantic HTML5 and modern CSS (flexbox/grid).
- Implement accessibility: ARIA labels, focus states, and keyboard navigation for all interactive elements.
- Use vanilla JavaScript (no modules, imports, exports, or bundlers) to power interactivity, validation, and dynamic behaviours.
- Include a call-to-action or contact mechanism when appropriate (e.g., forms with validation and success messaging).
- Inline CSS variables, utility classes, and subtle animations to create a premium look and feel.
- Provide a concise usage guide within the page so operators understand the generated experience.

## Trend Snapshot (latest 6 months)
| Month | Avg Price | Δ |
| --- | --- | --- |
| 2024-12 | $2,066.69 | +0.00 |
| 2025-01 | $2,085.51 | +18.82 |
| 2025-01 | $2,108.51 | +23.00 |
| 2025-03 | $2,133.96 | +25.45 |
| 2025-04 | $2,159.72 | +25.76 |
| 2025-05 | $2,183.64 | +23.92 |

## Insights
- Average trailing 12-month price: $2,174.02
- Year-over-year delta: +165.31 (upward trend)
- Best performing month: 2025-09
- Worst performing month: 2024-12